import {createStore, applyMiddleware, compose, combineReducers} from 'redux';
import {connectRouter, routerMiddleware} from 'connected-react-router';
import thunkMiddleware from 'redux-thunk';

import common from '@blocks/common/reducers';
import auth from './reducers/auth';
import am from './reducers/am';
import mailAuth from './reducers/mailAuth';
import messengerAuth from './reducers/messengerAuth';
import restoreLogin from './reducers/restoreLogin';
import restorePassword from './reducers/restorePassword';
import registerLite from './reducers/registerLite';
import mobileMenu from './reducers/mobileMenu';
import pagePopup from './reducers/pagePopup';
import captcha from '@components/Captcha/reducers';
import additionalDataRequest from './reducers/additionalDataRequest';
import avatar from '@blocks/avatar-displayname/reducers/avatar';
import challenge from './reducers/challenge';
import phoneConfirm from '@blocks/reducers/phoneConfirm';
import signup from '@blocks/SignUp/reducers';
import form from '@blocks/reducers/form';
import tracks from '@blocks/reducers/tracks';
import registrationErrors from '@blocks/registration/reducers/registrationErrors';
import logins from '@blocks/registration/reducers/logins';
import {userEntryFlow} from '@blocks/UserEntryFlow/reducers';
import {accountsSuggest} from '@blocks/reducers/accountsSuggest';
import {completeFlow} from '@blocks/AuthRegComplete/reducers/completeFlow';
import changePassword from './reducers/changePassword';
import {person} from './reducers/person';
import {socialSuggest} from './reducers/socialSuggest';
import {contextMenu} from './reducers/contextMenu';
import {createReduxMiddleware as createNativeMobileApiReduxMiddleware} from './nativeMobileApi';

export const stub = (state = {}) => state;

const rootReducer = (history) =>
    combineReducers({
        router: connectRouter(history),
        common,
        completeFlow,
        captcha,
        additionalDataRequest,
        avatar,
        mailAuth,
        messengerAuth,
        auth,
        am,
        mobileMenu,
        person,
        restoreLogin,
        restorePassword,
        changePassword,
        challenge,
        registerLite,
        pagePopup,
        metrics: stub,
        monitoring: stub,
        social: stub,
        customs: stub,
        settings: stub,
        phoneConfirm,
        signup,
        form,
        tracks,
        registrationErrors,
        logins,
        experimentsList: stub,
        userEntryFlow,
        accountsSuggest,
        socialSuggest,
        contextMenu
    });

export default function(initialState, history) {
    const devTools =
        typeof window === 'object' &&
        typeof window.__REDUX_DEVTOOLS_EXTENSION__ !== 'undefined' &&
        process.env.NODE_ENV !== 'production'
            ? window.__REDUX_DEVTOOLS_EXTENSION__()
            : (f) => f;

    const middlewares = [thunkMiddleware, routerMiddleware(history)];

    if (typeof window === 'object' && initialState.am && initialState.am.isAm) {
        middlewares.push(createNativeMobileApiReduxMiddleware(initialState));
    }

    return createStore(rootReducer(history), initialState, compose(applyMiddleware(...middlewares), devTools));
}
