import querystring from 'querystring';
import {Platforms} from './constants';

export function cleanAmQueryParams(store = {}) {
    const {am = {}} = store;

    if (!am.isAm || !am.clearUrlParams) {
        return;
    }

    const searchParams = querystring.parse(location.search.replace(/^\?/, ''));

    delete searchParams.app_platform;
    delete searchParams.app_id;
    delete searchParams.app_version_name;
    delete searchParams.am_version_name;
    delete searchParams.scheme;
    delete searchParams.theme;
    delete searchParams.lang;
    delete searchParams.locale;
    delete searchParams.source;
    delete searchParams.mode;
    delete searchParams.reg_type;
    delete searchParams.device_name;
    delete searchParams.uuid;
    delete searchParams.x_token_client_id;

    return `?${querystring.stringify(searchParams)}`;
}

export function setupMessageReceiver(store = {}) {
    if (store.am.platform === Platforms.IOS && !window.webkit) {
        window.webkit = {
            messageHandlers: {
                nativeAM: {
                    postMessage() {}
                }
            }
        };
    } else if (store.am.platform === Platforms.ANDROID && !window.nativeAMAndroid) {
        window.nativeAMAndroid = {
            send() {}
        };
    }
}

export function getAmBackPane(store = {}, page) {
    const {am = {}} = store;

    if (!am.isAm) {
        return null;
    }

    if (page === 'addAccountPage' && am.mode === 'welcome') {
        return store.am.finishCancelUrl;
    }

    return null;
}

export function amFlashcallExpOn(store = {}) {
    const {am = {}} = store;
    const {experiments = {}} = am;

    return am.isAm && experiments['reg_call_confirm_on'];
}

export function shouldForceConfirmPhoneBySMS(store = {}) {
    const {am = {}} = store;

    return am.isAm && !amFlashcallExpOn(store);
}
