import {STEPS} from '@blocks/UserEntryFlow/steps';
import {clearProcessError} from '@blocks/UserEntryFlow/actions';
import {onNext} from '@blocks/UserEntryFlow/logic';
import {getSteps, getProcessName} from '@blocks/UserEntryFlow/utils';
import {ENTRY_REGISTER_NEOPHONISH_PROCESS} from '@blocks/UserEntryFlow/processes';
import loginSubmit from '@blocks/authv2/actions/multiStepAuthStart';
import passwordSubmit from '@blocks/authv2/actions/multiStepAuthCommitPassword';
import sendApiRequest from '@blocks/authv2/actions/sendApiRequest';
import {updateLoginValue, updatePasswordValue} from '@blocks/authv2/actions/index.js';
import redirectToRetpath from '@blocks/authv2/actions/redirectToRetpath';
import {getFormValues, hasExp} from '@blocks/selectors';
import {updateValues} from '@blocks/actions/form';
import {FIELDS_NAMES} from '@components/Field/names';
import {commitAuthBySMS, FIELD_NAME as AUTH_BY_SMS_CODE_FIELD_NAME} from '@blocks/authv2/actions/authBySMS';
import {
    amSetAuthBySWC,
    saveSuggestedLoginFromSWC,
    amUpdateEulaStrings,
    setPrimaryActionTriggeredStatus
} from '@blocks/authv2/actions/nativeMobileApi';
import metrika from '@blocks/metrics';
import {RegType} from '@blocks/authv2/nativeMobileApi/constants';

export const onSmsSubmitedFromMobileApi = (code) => (dispatch, getState) => {
    const {userEntryFlow = {}, pagePopup = {}} = getState();
    const {step} = userEntryFlow;

    if (pagePopup.isShowPagePopup && pagePopup.pagePopupType === 'authConfirmationBySMS') {
        metrika.send(`Вставка смс кода из мобильного апи`);

        dispatch(updateValues({field: AUTH_BY_SMS_CODE_FIELD_NAME, value: code}));
        dispatch(commitAuthBySMS());

        return;
    }

    if (step === STEPS.PHONE_CONFIRM) {
        metrika.send(`Вставка смс кода из мобильного апи`);

        dispatch(clearProcessError());
        dispatch(updateValues({field: FIELDS_NAMES.PHONE_CODE, value: code}));
        dispatch(onNext(STEPS.PHONE_CONFIRM));

        return;
    }

    metrika.send(`Не удалось вставить смс код из нативного апи`);
};

export const onNativeMobileSWCResponse = (login, password, isFromDialog) => (dispatch) => {
    dispatch(amSetAuthBySWC(true));

    if (isFromDialog) {
        dispatch(
            sendApiRequest(loginSubmit, {login}, () => {
                dispatch(sendApiRequest(passwordSubmit, password));
            })
        );
    } else {
        dispatch(updateLoginValue(login));
        dispatch(updatePasswordValue(password));
        dispatch(saveSuggestedLoginFromSWC(login));
    }
};

export const onPhoneRegionCodeResponse = (phoneRegionCode) => (dispatch, getState) => {
    const currPhoneValue = getFormValues(getState())[FIELDS_NAMES.PHONE];

    if (!currPhoneValue) {
        dispatch(updateValues({field: FIELDS_NAMES.PHONE, value: phoneRegionCode}));
    }
};

export const onRequestPhoneNumberHintResponse = (phone) => (dispatch, getState) => {
    const state = getState();
    const {userEntryFlow = {}, customs: {isSkipEulaPage = false} = {}, am: {regType = ''} = {}} = state;
    const useNewSuggestByPhone = hasExp(state, 'use-new-suggest-by-phone') || regType === RegType.DOREGISH;

    dispatch(updateValues({field: FIELDS_NAMES.PHONE, value: phone}));

    const process = getProcessName(state);
    const steps = getSteps(process, useNewSuggestByPhone);
    const step = userEntryFlow.step || (Array.isArray(steps) && steps[0]);
    const isNotProcessError = userEntryFlow.processError.status === 'ok';
    const isEulaOnPage = isSkipEulaPage && process === ENTRY_REGISTER_NEOPHONISH_PROCESS && isNotProcessError;

    if (step === STEPS.PHONE && !isEulaOnPage) {
        dispatch(onNext(step));
    }
};

export const onStorePhoneNumberResponse = (isSuccess) => (dispatch, getState) => {
    const state = getState();
    const {am} = state;

    if (isSuccess) {
        dispatch(redirectToRetpath());

        return;
    }

    window.location = am.finishErrorUrl;
};

export const onCustomEulaStringsResponse = (response) => (dispatch) => {
    dispatch(amUpdateEulaStrings(response));
};

export const onSaveLoginCredentialsResponse = (payload = {}, successCb) => (_, getState) => {
    const state = getState();
    const {am} = state;

    if (payload && typeof payload === 'object') {
        if (!payload.status || !['ok', 'cancel'].includes(payload.status)) {
            metrika.send(`Ошибка сохранения логина в ам ${payload.error || ''}`);
        }
    }

    if (typeof successCb === 'function') {
        successCb();

        return;
    }

    window.location = am.finishErrorUrl;
};

export const onPrimaryActionTriggeredResponse = (isError) => (dispatch) => {
    dispatch(setPrimaryActionTriggeredStatus(isError));
};
