import {NATIVE_MOBILE_API_OUTGOING_ACTIONS, updateSavedExperiments} from '@blocks/authv2/actions/nativeMobileApi';
import {updateValues} from '@blocks/actions/form';
import {Messages} from './constants';
import {
    onSmsSubmitedFromMobileApi,
    onNativeMobileSWCResponse,
    onPhoneRegionCodeResponse,
    onRequestPhoneNumberHintResponse,
    onStorePhoneNumberResponse,
    onCustomEulaStringsResponse,
    onSaveLoginCredentialsResponse,
    onPrimaryActionTriggeredResponse
} from './logic';

function validateMessageFromNativeApi(payload = {}, properties = []) {
    return payload && typeof payload === 'object' && properties.every((property) => payload.hasOwnProperty(property));
}

export function handleNativeMobileApiIncomingAction(_, action) {
    switch (action.type) {
        default:
            break;
    }
}

export function handleNativeMobileApiOutgoingAction(store, action, mobileApiTransport) {
    const {type, payload = {}} = action;

    switch (type) {
        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_SMS:
            mobileApiTransport.sendMessageToNativeApi(Messages.GET_SMS, {}, (payload) => {
                if (validateMessageFromNativeApi(payload, ['value'])) {
                    store.dispatch(onSmsSubmitedFromMobileApi(payload.value));
                }
            });

            break;
        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_OTP:
            mobileApiTransport.sendMessageToNativeApi(Messages.GET_OTP, payload, (payload) => {
                if (validateMessageFromNativeApi(payload, ['value'])) {
                    store.dispatch(updateValues({field: 'otp', value: payload.value}));
                }
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.AUTH_SUCCEED:
            mobileApiTransport.sendMessageToNativeApi(
                Messages.SAVE_LOGIN_CREDENTIALS,
                {
                    login: action.payload.login,
                    password: action.payload.password,
                    avatarUrl: action.payload.avatarUrl
                },
                (payload) => {
                    store.dispatch(onSaveLoginCredentialsResponse(payload, action.payload.successCb));
                }
            );

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.READY:
            mobileApiTransport.sendMessageToNativeApi(Messages.READY, {
                status: action.payload.status
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.SET_POPUP_SIZE:
            if (payload.options) {
                payload.options.hasOwnProperty('height')
                    ? mobileApiTransport.sendMessageToNativeApi(Messages.SET_POPUP_SIZE, {
                          mode: payload.options.mode,
                          corner_radius: payload.options.cornerRadius,
                          horizontal_margins: payload.options.horizontalMargins,
                          vertical_margins: payload.options.verticalMargins,
                          height: payload.options.height
                      })
                    : mobileApiTransport.sendMessageToNativeApi(Messages.SET_POPUP_SIZE, {
                          mode: payload.options.mode,
                          corner_radius: payload.options.cornerRadius,
                          horizontal_margins: payload.options.horizontalMargins,
                          vertical_margins: payload.options.verticalMargins
                      });
            }

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.CLOSE:
            mobileApiTransport.sendMessageToNativeApi(Messages.CLOSE, {});

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.PRIMARY_ACTION_TRIGGERED:
            mobileApiTransport.sendMessageToNativeApi(Messages.PRIMARY_ACTION_TRIGGERED, {}, (payload) => {
                store.dispatch(
                    onPrimaryActionTriggeredResponse(
                        validateMessageFromNativeApi(payload, ['status']) && payload.status !== 'ok'
                    )
                );
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.BEGIN_CHANGE_PASSWORD_FLOW:
            mobileApiTransport.sendMessageToNativeApi(Messages.BEGIN_CHANGE_PASSWORD_FLOW, {});

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.CHOOSE_ACCOUNT:
            mobileApiTransport.sendMessageToNativeApi(Messages.CHOOSE_ACCOUNT, {
                mask: action.payload.mask
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.REQUEST_SWC:
            mobileApiTransport.sendMessageToNativeApiOnce(Messages.REQUEST_SWC, {}, (payload) => {
                if (validateMessageFromNativeApi(payload, ['login', 'password', 'isFromDialog'])) {
                    store.dispatch(onNativeMobileSWCResponse(payload.login, payload.password, payload.isFromDialog));
                }
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.START_SOCIAL_AUTH:
            mobileApiTransport.sendMessageToNativeApi(Messages.SOCIAL_AUTH, {
                provider: action.payload.provider
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.START_SAML_SSO_AUTH:
            mobileApiTransport.sendMessageToNativeApi(Messages.SAML_SSO_AUTH, {
                samlSsoUrl: action.payload.samlSsoUrl
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.SHOW_DEBUG_INFO:
            mobileApiTransport.sendMessageToNativeApi(Messages.SHOW_DEBUG_INFO, {});

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.SEND_METRICS:
            mobileApiTransport.sendMessageToNativeApi(Messages.SEND_METRICS, {
                identifier: action.payload.identifier,
                parameters: action.payload.parameters
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_PHONE_REGION_CODE:
            mobileApiTransport.sendMessageToNativeApi(Messages.GET_PHONE_REGION_CODE, {}, (payload) => {
                if (validateMessageFromNativeApi(payload, ['phoneRegionCode'])) {
                    store.dispatch(onPhoneRegionCodeResponse(payload.phoneRegionCode));
                }
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.REQUEST_SAVED_EXPERIMENTS:
            mobileApiTransport.sendMessageToNativeApi(Messages.REQUEST_SAVED_EXPERIMENTS, {}, (payload) => {
                if (validateMessageFromNativeApi(payload)) {
                    store.dispatch(updateSavedExperiments(payload));
                }
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.REQUEST_PHONE_NUMBER_HINT:
            mobileApiTransport.sendMessageToNativeApi(Messages.REQUEST_PHONE_NUMBER_HINT, {}, (payload) => {
                if (validateMessageFromNativeApi(payload, ['phoneNumber'])) {
                    store.dispatch(onRequestPhoneNumberHintResponse(payload.phoneNumber));
                }
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.STORE_PHONE_NUMBER:
            mobileApiTransport.sendMessageToNativeApi(
                Messages.STORE_PHONE_NUMBER,
                {
                    phoneNumber: action.payload.phoneNumber
                },
                (payload) => {
                    store.dispatch(
                        onStorePhoneNumberResponse(
                            validateMessageFromNativeApi(payload, ['status']) && payload.status === 'ok'
                        )
                    );
                }
            );

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.STORE_ICLOUD_TOKEN:
            mobileApiTransport.sendMessageToNativeApi(Messages.STORE_ICLOUD_TOKEN, {
                token: action.payload.token
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_CUSTOM_EULA_STRINGS:
            mobileApiTransport.sendMessageToNativeApi(Messages.GET_CUSTOM_EULA_STRINGS, {}, (payload) => {
                if (validateMessageFromNativeApi(payload)) {
                    store.dispatch(onCustomEulaStringsResponse(payload));
                }
            });

            break;

        case NATIVE_MOBILE_API_OUTGOING_ACTIONS.DELETED_ACCOUNT_AUTH:
            mobileApiTransport.sendMessageToNativeApi(Messages.DELETED_ACCOUNT_AUTH, {});

            break;

        default:
            break;
    }
}
