import {
    NATIVE_MOBILE_API_INCOMING_ACTIONS,
    NATIVE_MOBILE_API_OUTGOING_ACTIONS
} from '@blocks/authv2/actions/nativeMobileApi';
import {handleNativeMobileApiIncomingAction, handleNativeMobileApiOutgoingAction} from './messageHandlers';
import {NativeMobileApiTransport} from './NativeMobileApiTransport';
import {setupMessageReceiver} from './helpers';

function objectValues(object = {}) {
    return Object.keys(object).map((key) => object[key]);
}

export function isNativeMobileApiIncomingAction(action = {}) {
    return objectValues(NATIVE_MOBILE_API_INCOMING_ACTIONS).includes(action.type);
}

export function isNativeMobileApiOutgoingAction(action = {}) {
    return objectValues(NATIVE_MOBILE_API_OUTGOING_ACTIONS).includes(action.type);
}

export const createReduxMiddleware = (initialState = {}) => {
    const {am = {}} = initialState;

    if (am.debug) {
        setupMessageReceiver(initialState);
    }

    const nativeMobileApiTransport = new NativeMobileApiTransport(0, am.platform, {
        logEvents: am.debug
    });

    if (am.debug) {
        window.__AM_NATIVE_MOBILE_TRANSPORT__ = nativeMobileApiTransport;
    }

    return (store) => (next) => (action) => {
        if (isNativeMobileApiIncomingAction(action)) {
            setTimeout(() => {
                handleNativeMobileApiIncomingAction(store, action);
            }, 0);
        }

        if (isNativeMobileApiOutgoingAction(action)) {
            setTimeout(() => {
                handleNativeMobileApiOutgoingAction(store, action, nativeMobileApiTransport);
            }, 0);
        }

        return next(action);
    };
};
