import React, {Component} from 'react';
import {connect} from 'react-redux';
import classnames from 'classnames';
import PropTypes from 'prop-types';
import {SHOW_LOGIN_FORM, SHOW_LOGIN_FORM_GOAL} from '@blocks/authv2/metrics_constants';
import LoginForm from '@blocks/authv2/components/LoginForm/LoginForm.jsx';
import {SocialBlock} from '@blocks/authv2/components/SocialBlock';
import Page from '@blocks/authv2/components/Page/Page.jsx';
import Title from '@blocks/authv2/components/Title/Title.jsx';
import {DomikFooterLink} from '@blocks/authv2/components/DomikFooterLink';
import metrics from '@blocks/metrics';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';

class AddAccountPage extends Component {
    componentDidMount() {
        const {setupBackPane, setupMode, setupPane, addUserUrl, editUrl, hasUnitedAccounts, isAm} = this.props;

        if (!isAm && hasUnitedAccounts) {
            setupBackPane(editUrl);
        }

        setupMode('addingAccount');
        setupPane(addUserUrl);

        metrics.send([SHOW_LOGIN_FORM]);
        metrics.goal(SHOW_LOGIN_FORM_GOAL);

        if (this.props.onMount && typeof this.props.onMount === 'function') {
            this.props.onMount();
        }
    }

    // componentWillUnmount() {
    //     const {canRegister} = this.props;

    //     canRegister({isCanRegister: false});
    // }

    maybeRenderHelpLink = () => {
        const {origin, yandexSupportUrl} = this.props;

        if (origin === 'china') {
            return (
                <DomikFooterLink target='_blank' href={yandexSupportUrl} dataT='passp:support-link'>
                    {i18n('_AUTH_.report_a_problem')}
                </DomikFooterLink>
            );
        }
    };

    render() {
        const {
            isCanRegister,
            isFullScreen,
            customTagline,
            hideTagline,
            isWebView,
            isWebViewWithSocialAuth,
            hideSocialBlock
        } = this.props;

        return (
            <Page cls='add-account' dataT='add-account'>
                <div
                    className={classnames({
                        'passp-add-account-page_has-social-block': true,
                        'passp-add-account-page_can-register': isCanRegister
                    })}
                >
                    {!hideTagline && (
                        <Title>
                            <span
                                className={classnames('passp-add-account-page-title', {
                                    'passp-add-account-page-title_isFullScreen': isFullScreen
                                })}
                                dangerouslySetInnerHTML={{__html: customTagline}}
                            />
                        </Title>
                    )}

                    <LoginForm />

                    {!hideSocialBlock && (!isWebView || isWebViewWithSocialAuth) && <SocialBlock />}
                </div>

                {this.maybeRenderHelpLink()}
            </Page>
        );
    }
}

AddAccountPage.propTypes = {
    isWebView: PropTypes.bool,
    isWebViewWithSocialAuth: PropTypes.bool,
    isCanRegister: PropTypes.bool.isRequired,
    isFullScreen: PropTypes.bool,
    customTagline: PropTypes.string.isRequired,
    hideTagline: PropTypes.bool,
    setupBackPane: PropTypes.func.isRequired,
    canRegister: PropTypes.func.isRequired,
    setupMode: PropTypes.func.isRequired,
    setupPane: PropTypes.func.isRequired,
    addUserUrl: PropTypes.string,
    editUrl: PropTypes.string,
    onMount: PropTypes.func,
    hasUnitedAccounts: PropTypes.bool,
    origin: PropTypes.string,
    yandexSupportUrl: PropTypes.string.isRequired,
    isAm: PropTypes.bool,
    hideSocialBlock: PropTypes.bool
};

export default connect(mapStateToProps, mapDispatchToProps)(AddAccountPage);
