import {bindActionCreators} from 'redux';

import {onAuthMount} from '@blocks/authv2/actions/nativeMobileApi';
import {setupBackPane, canRegister, setupMode} from '../../actions';
import {setupPane} from '../../../common/actions';

export default function mapDispatchToProps(dispatch) {
    const actionCreators = {
        setupBackPane,
        canRegister,
        setupMode,
        setupPane,
        onMount: onAuthMount
    };

    return Object.assign({}, bindActionCreators(actionCreators, dispatch), {dispatch});
}
