import {isBookQREnabled} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        auth: {
            form: {isCanRegister},
            unitedAccounts = {},
            isAuthButtonAndTextExp,
            authButtonAndTextExperimentNumber
        },
        common = {},
        customs: {tagline, isFullScreen = false, hideTagline = false, hideSocialBlock = false} = {},
        am = {}
    } = state;

    const {
        addUserUrl,
        editUrl,
        isWebView,
        isWebViewWithSocialAuth,
        origin,
        yandex_support_url: yandexSupportUrl
    } = common;

    const hasUnitedAccounts = Object.keys(unitedAccounts).length > 0;

    let customTagline = i18n('_AUTH_.sign_in_title.yandexid');

    if (isAuthButtonAndTextExp) {
        customTagline = [2, 4].includes(authButtonAndTextExperimentNumber)
            ? i18n('_AUTH_.sign_in_title.exp.v2')
            : i18n('_AUTH_.sign_in_title.v2');
    }

    if (tagline) {
        customTagline = tagline;
    }

    return {
        addUserUrl,
        editUrl,
        isCanRegister,
        isFullScreen,
        hasUnitedAccounts,
        customTagline,
        hideTagline: hideTagline || isBookQREnabled(state),
        isWebView,
        isWebViewWithSocialAuth,
        origin,
        yandexSupportUrl,
        isAm: am.isAm,
        hideSocialBlock
    };
}
