import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';

import AuthWithLetterInfo from '../../components/AuthWithLetterInfo/AuthWIthLetterInfo.jsx';
import AuthLetterAccountConfirmed from '../../components/AuthLetterAccountConfirmed/AuthLetterAccountConfirmed.jsx';
import AuthWithLetterCancellation from '../../components/AuthWIthLetterCancellation/AuthWithLetterCancellation.jsx';

import confirmAuthFromLetter from '../../actions/confirmAuthFromLetter';
import invalidateAuthFromLetter from '../../actions/invalidateAuthFromLetter';

import {
    SHOW_AUTH_LETTER_CONFIRMATION_PAGE,
    SHOW_AUTH_MESSENGER_CONFIRMATION_PAGE,
    AUTH_MESSENGER_ALLOW_AUTH,
    AUTH_MESSENGER_DENY_AUTH,
    AUTH_LETTER_DENY_AUTH,
    AUTH_LETTER_ALLOW_AUTH
} from '../../metrics_constants';
import metrics from '../../../metrics';
import errors from '../../errors';
import authWithLetterErrors from '../../components/AuthWithLetterInfo/authWithLetterErrors';

export class AuthWithLetterPage extends Component {
    constructor(props) {
        super(props);

        this.confirmAuth = this.confirmAuth.bind(this);
        this.denyAuth = this.denyAuth.bind(this);
    }

    componentDidMount() {
        const {isMessengerAuth} = this.props;
        const metricsConst = isMessengerAuth
            ? SHOW_AUTH_MESSENGER_CONFIRMATION_PAGE
            : SHOW_AUTH_LETTER_CONFIRMATION_PAGE;

        metrics.send([metricsConst]);
    }

    denyAuth() {
        const {isMessengerAuth, dispatch} = this.props;
        const metricsConst = isMessengerAuth ? AUTH_MESSENGER_DENY_AUTH : AUTH_LETTER_DENY_AUTH;

        dispatch(invalidateAuthFromLetter());
        metrics.send([metricsConst]);
    }

    confirmAuth() {
        const {isMessengerAuth, dispatch} = this.props;
        const metricsConst = isMessengerAuth ? AUTH_MESSENGER_ALLOW_AUTH : AUTH_LETTER_ALLOW_AUTH;

        metrics.send([metricsConst]);
        dispatch(confirmAuthFromLetter());
    }

    render() {
        const {mailAuth, isError, staticPath, isAuthCancelled, isAuthConfirmed, errorText} = this.props;

        if (isError) {
            return <div dangerouslySetInnerHTML={{__html: errorText}} />;
        }

        return (
            <>
                <AuthLetterAccountConfirmed
                    isAuthConfirmed={isAuthConfirmed}
                    isRegister={mailAuth.isRegister}
                    login={mailAuth.login}
                    deviceInfo={mailAuth.browser}
                    retpath={mailAuth.retpath}
                    staticPath={staticPath}
                />
                <AuthWithLetterCancellation isAuthCancelled={isAuthCancelled} />
                <AuthWithLetterInfo
                    isInfoRenders={!isAuthConfirmed && !isAuthCancelled}
                    login={mailAuth.login}
                    isRegister={mailAuth.isRegister}
                    staticPath={staticPath}
                    denyLetterAuth={this.denyAuth}
                    confirmLetterAuth={this.confirmAuth}
                    deviceInfo={mailAuth.browser}
                />
            </>
        );
    }

    static mapStateToProps(state) {
        const {
            mailAuth,
            messengerAuth: {isEnable: isMessengerAuth},
            settings: {staticPath}
        } = state;
        const error = mailAuth.mailAuthError;
        const isError = error !== undefined;
        const {isAuthCancelled, isAuthConfirmed} = mailAuth;
        const errorsList = Object.assign({}, errors, authWithLetterErrors);
        const errorText = errors[error] !== undefined ? errorsList[error] : i18n('_AUTH_.MagicLink.invalid');

        return {
            mailAuth,
            isMessengerAuth,
            staticPath,
            isError,
            isAuthCancelled,
            isAuthConfirmed,
            errorText
        };
    }
}

export default connect(AuthWithLetterPage.mapStateToProps)(AuthWithLetterPage);

AuthWithLetterPage.propTypes = {
    mailAuth: PropTypes.object,
    isMessengerAuth: PropTypes.bool,
    staticPath: PropTypes.string.isRequired,
    isError: PropTypes.bool.isRequired,
    isAuthCancelled: PropTypes.bool.isRequired,
    isAuthConfirmed: PropTypes.bool,
    errorText: PropTypes.string,
    dispatch: PropTypes.func.isRequired
};
