export default function mapStateToProps(state) {
    const {
        challenge = {},
        customs: {isWhiteLabel = false} = {},
        am: {isAm, appId} = {},
        common: {authUrl} = {}
    } = state;
    const {
        challengeType,
        hint,
        fieldValue,
        errorText,
        errorCode,
        alternative,
        isSms2faChallenge,
        url3ds = '',
        is3dsLoading,
        isOneStep3dsExp,
        isTrustFrameOpened = false
    } = challenge;

    return {
        challengeType,
        hint,
        fieldValue,
        errorText,
        errorCode,
        alternative,
        isSms2faChallenge,
        isWhiteLabel,
        is3dsChallenge: challengeType === '3ds',
        url3ds,
        isOneStep3dsExp,
        is3dsLoading,
        isAm,
        appId,
        isTrustFrameOpened,
        authUrl
    };
}
