import React, {Component, Fragment} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import EnterEmailForm from '../../components/EnterEmailForm/EnterEmailForm.jsx';
import ConfirmRestoreEmailForm from '../../components/ConfirmRestoreEmailForm/ConfirmRestoreEmailForm.jsx';

import requestEmailConfirmationCode from '../../actions/requestEmailConfirmationCode';
import setupConfirmedEmail from '../../actions/setupConfirmedEmail';
import skipAdditionalData from '../../actions/skipAdditionalData';
import Page from '../../components/Page/Page.jsx';
import Title from '../../components/Title/Title.jsx';

class EmailRequestPage extends Component {
    constructor(props) {
        super(props);

        this.handleEmailChange = this.handleEmailChange.bind(this);
        this.sentConfirmationCode = this.sentConfirmationCode.bind(this);
        this.confirmRestoreEmail = this.confirmRestoreEmail.bind(this);
        this.goToEmailsPage = this.goToEmailsPage.bind(this);
        this.goBack = this.goBack.bind(this);
    }

    componentDidMount() {
        const {sendAdditionalDataRequestMetrics} = this.props;

        sendAdditionalDataRequestMetrics('show_email', null, 'Показ');
    }

    handleEmailChange(value) {
        const {changeEmail} = this.props;

        changeEmail(value);
    }

    sentConfirmationCode(event) {
        event.preventDefault();

        const {sendApiRequest, email} = this.props;

        sendApiRequest(requestEmailConfirmationCode, email);
    }

    confirmRestoreEmail(event) {
        event.preventDefault();

        const {sendApiRequest, email} = this.props;

        sendApiRequest(setupConfirmedEmail, email);
    }

    goToEmailsPage() {
        const {redirectToEmailsPage} = this.props;

        redirectToEmailsPage();
    }

    goBack() {
        const {sendAdditionalDataRequestMetrics, sendApiRequest} = this.props;

        sendAdditionalDataRequestMetrics('skip_email', null, 'Отложить');
        sendApiRequest(skipAdditionalData);
    }

    render() {
        const {action, isCaptchaRequired, email, errors} = this.props;

        return (
            <Page cls='email-request' dataT='email-request'>
                {(action === 'add' || action === 'confirm') && (
                    <Fragment>
                        <Title>
                            {action === 'add'
                                ? i18n('_AUTH_.email.add-email.title.v2')
                                : i18n('_AUTH_.email.confirm-email.title.v2')}
                        </Title>

                        <EnterEmailForm
                            handleEmailChange={this.handleEmailChange}
                            sentConfirmationCode={this.sentConfirmationCode}
                            goBack={this.goBack}
                            action={action}
                            isCaptchaRequired={isCaptchaRequired}
                            email={email}
                            errors={errors}
                        />
                    </Fragment>
                )}

                {action === 'restore' && (
                    <Fragment>
                        <Title>
                            <span
                                dangerouslySetInnerHTML={{
                                    __html: i18n('_AUTH_.email.restore.title.v2').replace('%1', `<b>${email}</b>`)
                                }}
                            />
                        </Title>

                        <ConfirmRestoreEmailForm
                            confirmRestoreEmail={this.confirmRestoreEmail}
                            goToEmailsPage={this.goToEmailsPage}
                            goBack={this.goBack}
                            email={email}
                            isCaptchaRequired={isCaptchaRequired}
                            errors={errors}
                        />
                    </Fragment>
                )}
            </Page>
        );
    }
}

EmailRequestPage.propTypes = {
    action: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool,
    email: PropTypes.string,
    errors: PropTypes.array,
    changeEmail: PropTypes.func.isRequired,
    sendApiRequest: PropTypes.func.isRequired,
    redirectToEmailsPage: PropTypes.func.isRequired,
    sendAdditionalDataRequestMetrics: PropTypes.func.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(EmailRequestPage);
