import React, {Component} from 'react';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import PropTypes from 'prop-types';
import {setupBackPane, setupMode} from '@blocks/authv2/actions';
import {setupPane} from '@blocks/common/actions';
import {SHOW_SUGGEST_LIST_GOAL, SHOW_SUGGEST_LIST} from '@blocks/authv2/metrics_constants';
import {DomikFooterLink} from '@blocks/authv2/components/DomikFooterLink';
import AccountList from '@blocks/authv2/components/AccountList/AccountList.jsx';
import Page from '@blocks/authv2/components/Page/Page.jsx';
import Title from '@blocks/authv2/components/Title/Title.jsx';
import metrics from '@blocks/metrics';

class ListPage extends Component {
    componentDidMount() {
        const {setupBackPane, setupMode, setupPane, editUrl} = this.props;

        metrics.goal(SHOW_SUGGEST_LIST_GOAL);
        metrics.send([SHOW_SUGGEST_LIST]);

        setupBackPane(null);
        setupMode('edit');
        setupPane(editUrl);
    }

    maybeRenderHelpLink = () => {
        const {origin, yandexSupportUrl} = this.props;

        if (origin === 'china') {
            return (
                <DomikFooterLink target='_blank' href={yandexSupportUrl} dataT='passp:support-url'>
                    {i18n('_AUTH_.report_a_problem')}
                </DomikFooterLink>
            );
        }
    };

    render() {
        return (
            <Page cls='list' dataT='list'>
                <Title>{i18n('_AUTH_.AccountList.title.auth')}</Title>

                <AccountList />

                {this.maybeRenderHelpLink()}
            </Page>
        );
    }

    static mapStateToProps(state) {
        const {common = {}} = state;
        const {editUrl, origin, yandex_support_url: yandexSupportUrl} = common;

        return {
            editUrl,
            origin,
            yandexSupportUrl
        };
    }

    static mapDispatchToProps(dispatch) {
        const actionCreators = {
            setupBackPane,
            setupPane,
            setupMode
        };

        return Object.assign({}, bindActionCreators(actionCreators, dispatch), {dispatch});
    }
}

ListPage.propTypes = {
    editUrl: PropTypes.string.isRequired,
    setupBackPane: PropTypes.func.isRequired,
    setupPane: PropTypes.func.isRequired,
    setupMode: PropTypes.func.isRequired,
    origin: PropTypes.string,
    yandexSupportUrl: PropTypes.string.isRequired
};

export default connect(ListPage.mapStateToProps, ListPage.mapDispatchToProps)(ListPage);
