import React from 'react';
import PropTypes from 'prop-types';
import {DOT_AMOUNT} from './constants';

export const Circle = ({index, colors, getPosition, currentProgress}) => {
    const pos = getPosition(index);

    if (!pos) {
        return;
    }

    const dotPercent = (index / DOT_AMOUNT) * 100;
    const colorIndex = colors.findIndex(({positionPercent}) => positionPercent > Math.floor(dotPercent));
    const colorMin = colors[colorIndex - 1];
    const colorMax = colors[colorIndex];
    const color = {
        r:
            colorMin.r +
            ((colorMax.r - colorMin.r) / (colorMax.positionPercent - colorMin.positionPercent)) *
                (dotPercent - colorMin.positionPercent),
        g:
            colorMin.g +
            ((colorMax.g - colorMin.g) / (colorMax.positionPercent - colorMin.positionPercent)) *
                (dotPercent - colorMin.positionPercent),
        b:
            colorMin.b +
            ((colorMax.b - colorMin.b) / (colorMax.positionPercent - colorMin.positionPercent)) *
                (dotPercent - colorMin.positionPercent)
    };

    return (
        <circle
            key={index}
            cx={pos.x}
            cy={pos.y}
            r='2.5'
            fillOpacity={index >= currentProgress * DOT_AMOUNT ? 1 : 0}
            fill={`rgb(${color.r},${color.g},${color.b})`}
        />
    );
};

Circle.propTypes = {
    index: PropTypes.number,
    colors: PropTypes.array,
    currentProgress: PropTypes.number,
    getPosition: PropTypes.func
};
