import React, {useRef, useCallback, useState, useEffect} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {DOT_AMOUNT, ONE_MINUTE_MS, COLORS, COLORS_RED} from './constants';
import {Circles} from './Circles';

import './CircleProgress.styl';

const b = cn('CircleProgress');

export const CircleProgress = React.memo(({startTime, onTimeOver}) => {
    const progressBarMeterRef = useRef(null);
    const [currentProgress, setCurrentProgress] = useState(0);

    useEffect(() => {
        const interval = setInterval(() => {
            const progress = Math.min((Date.now() - startTime) / ONE_MINUTE_MS, 100);

            setCurrentProgress(progress);
            if (Math.floor(progress) >= 1) {
                clearInterval(interval);
                onTimeOver();
            }
        }, 1000 / 60);

        return () => clearInterval(interval);
    }, [startTime, onTimeOver]);
    const CIRCUMFERENCE = progressBarMeterRef.current ? progressBarMeterRef.current.getTotalLength() : 1;
    const UNIT = CIRCUMFERENCE / DOT_AMOUNT;

    const getPosition = useCallback(
        (index) => progressBarMeterRef.current && progressBarMeterRef.current.getPointAtLength(index * UNIT),
        [UNIT]
    );

    return (
        <svg className={b('progressBar')} viewBox='-2 -2 124 124'>
            <path
                className={b('progressBarMeter')}
                d='M60,6A54,54 0 0 1 60,114A54,54 0 0 1 60,6z'
                strokeWidth='12'
                ref={progressBarMeterRef}
            />
            <Circles
                getPosition={getPosition}
                colors={currentProgress > 0.9 ? COLORS_RED : COLORS}
                currentProgress={currentProgress}
            />
        </svg>
    );
});

CircleProgress.propTypes = {
    startTime: PropTypes.number.isRequired,
    onTimeOver: PropTypes.func.isRequired
};
