import React from 'react';
import PropTypes from 'prop-types';
import {DOT_AMOUNT} from './constants';
import {Circle} from './Circle';

const preparedDotsArray = new Array(DOT_AMOUNT).fill(null);

export const Circles = React.memo(({getPosition, colors, currentProgress}) => {
    return (
        <g>
            {preparedDotsArray.map((_, index) => (
                <Circle
                    key={index}
                    getPosition={getPosition}
                    colors={colors}
                    currentProgress={currentProgress}
                    index={index}
                />
            ))}
        </g>
    );
});

Circles.propTypes = {
    getPosition: PropTypes.func.isRequired,
    colors: PropTypes.array.isRequired,
    currentProgress: PropTypes.number.isRequired
};
