import magic from '@blocks/authv2/magic';
import {setMagicError, updatePasswordValue, setTypeImage2FA} from '@blocks/authv2/actions';
import multiStepAuthCommitPassword from '@blocks/authv2/actions/multiStepAuthCommitPassword';
import sendApiRequest from '@blocks/authv2/actions/sendApiRequest';
import multiStepAuthStartForMagic from '@blocks/authv2/actions/multiStepAuthStartForMagic';
import authPasswordSubmitForMagic from '@blocks/authv2/actions/authPasswordSubmitForMagic';

export function mapDispatchToProps(dispatch) {
    return {
        changePasswordValue(value) {
            dispatch(updatePasswordValue(value));
        },
        setType2FA(type2FA, login) {
            magic.stop();
            dispatch(setMagicError(''));
            dispatch(setTypeImage2FA(type2FA));
            dispatch(multiStepAuthStartForMagic(login));
            dispatch(authPasswordSubmitForMagic());
        },
        submitOTP(password) {
            dispatch(sendApiRequest(multiStepAuthCommitPassword, password));
        },
        updateImage(login) {
            dispatch(multiStepAuthStartForMagic(login));
            dispatch(authPasswordSubmitForMagic());
            dispatch(setMagicError(''));
        }
    };
}
