import errors from '@blocks/authv2/errors';

export function mapStateToProps(state = {}) {
    const {common = {}, auth = {}, settings = {}} = state;
    const {authUrl, track_id: trackId, csrf} = common;
    const {authCustomsStatic} = settings;
    const {
        auth2faPictures = {},
        form: {password, login},
        passwordError,
        loading,
        magicError,
        isMagicSuccess,
        typeImage2FA: type2FA
    } = auth;
    const hasCaptcha = Boolean(passwordError && passwordError.indexOf('captcha') > -1);
    const {count_left: attemptsAmount, correct: correctImageNumber, expires_at: expiresAt} = auth2faPictures;
    const keyPicturesUrl = `${authCustomsStatic}/assets/key-pictures/`;
    const fieldError = (magicError && (errors[magicError] || errors.global)) || null;

    return {
        authUrl,
        attemptsAmount,
        correctImageNumber,
        csrf,
        expiresAt,
        hasCaptcha,
        keyPicturesUrl,
        loading,
        login,
        magicError,
        password,
        trackId,
        type2FA,
        fieldError,
        isMagicSuccess
    };
}
