import {bindActionCreators} from 'redux';

import authPasswordSubmitForMagic from '../../actions/authPasswordSubmitForMagic';
import {setupPane} from '../../../common/actions';
import {forceOTPMethod, setupMode} from '../../actions';
import switchToModeAddingAccount from '../../actions/switchToModeAddingAccount';
import multiStepAuthStartForMagic from '../../actions/multiStepAuthStartForMagic';

export default function mapDispatchToProps(dispatch) {
    const actionCreators = {
        setupMode,
        setupPane,
        switchToModeAddingAccount,
        authPasswordSubmitForMagic,
        multiStepAuthStartForMagic,
        forceOTPMethod
    };

    return Object.assign({}, bindActionCreators(actionCreators, dispatch), {dispatch});
}
