import errors from '../../errors';
import {getLanguage, hasExp} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        common: {magicUrl, addUserUrl, editUrl, isWebView},
        auth: {
            magicError,
            isFromLoginSuggest,
            isQRAuthEnabled,
            processedAccount: account,
            form: {login},
            magicTrack: trackId,
            magicCSRF: magicCSRFToken,
            isCaptchaRequired,
            isMagicSuccess
        },
        settings: {
            language,
            tld,
            ua: {isTouch}
        }
    } = state;

    const authMethods = (account && account.allowed_auth_methods) || [];
    const fieldError = (magicError && (errors[magicError] || errors.global)) || null;
    const hasSocialAuthMethod = authMethods.some((method) => method.indexOf('social_') > -1);
    const hasMagicAuthMethod = authMethods.indexOf('magic') > -1;
    const hasQRAuthMethod = authMethods.indexOf('magic_x_token') > -1;
    const isAccountWith2FA = authMethods.includes('magic') && authMethods.includes('otp');
    const isQRAuth = Boolean(isQRAuthEnabled && ((isFromLoginSuggest && hasQRAuthMethod) || !isFromLoginSuggest));
    const is2faWithImage = isAccountWith2FA && hasExp(state, 'is-2fa-with-image');
    const isSocialAccount = Boolean(
        authMethods.length &&
            !authMethods.some((method) => method.indexOf('social_') === -1 && method !== 'magic_x_token')
    );
    const YaIconPostfix = ['ru', 'by', 'uk'].includes(language) ? 'ru' : 'en';
    const texts = defineTextsAccordingAuthType(login, isAccountWith2FA, YaIconPostfix);

    let fallbackLinkText = i18n('_AUTH_.magic.qrcode_broken');

    if (isQRAuth) {
        if (!hasMagicAuthMethod) {
            fallbackLinkText =
                isFromLoginSuggest && !hasSocialAuthMethod
                    ? i18n('_AUTH_.QrAuth.fallback-link.v2')
                    : i18n('_AUTH_.QrAuth.fallback-link');
        }

        // Удалить после решения PASSP-22837
        if (isSocialAccount) {
            fallbackLinkText = i18n('_AUTH_.QrAuth.fallback-link.v3');
        }

        if (!isFromLoginSuggest) {
            fallbackLinkText = i18n('_AUTH_.QrAuth.fallback-link');
        }
    }

    return {
        magicUrl,
        addUserUrl,
        editUrl,
        isFromLoginSuggest,
        trackId,
        magicCSRFToken,
        login,
        tld,
        isTouch,
        isWebView,
        is2faWithImage,
        fieldError,
        fallbackLinkText,
        isSocialAccount,
        texts,
        isAccountWith2FA,
        language: getLanguage(state),
        isCaptchaRequired,
        isMagicSuccess
    };
}

function defineTextsAccordingAuthType(login, isAccountWith2FA, YaIconPostfix) {
    const QRTextWithIconNoLogin = i18n('_AUTH_.magic_qr-key_icon-text-v2');
    const yandexIconHTML =
        YaIconPostfix === 'ru'
            ? '<span class="passp-magic__icon-yandex-ru" aria-hidden="true"></span>'
            : '<span class="passp-magic__icon-yandex-en" aria-hidden="true"></span>';
    const cameraIconHTML = '<span class="passp-magic__photo-icon" aria-hidden="true"></span>';
    const texts = {
        title: i18n('_AUTH_.AuthQR.promo.page_title'),
        descriptionText: QRTextWithIconNoLogin.replace('%s', yandexIconHTML).replace('%s', cameraIconHTML)
    };

    if (!login) {
        texts.title = i18n('_AUTH_.AuthQR.promo.page_title_no-login');
        texts.descriptionText = QRTextWithIconNoLogin.replace('%s', yandexIconHTML).replace('%s', cameraIconHTML);
    }

    if (isAccountWith2FA) {
        texts.title = i18n('_AUTH_.magic.enter_with_key');
        texts.descriptionText = i18n('_AUTH_.magic.enter_with_key_qr');
    }

    return texts;
}
