import React, {Component, Fragment} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import EnterPhoneForm from '../../components/EnterPhoneForm/EnterPhoneForm.jsx';
import ConfirmActualPhoneForm from '../../components/ConfirmActualPhoneForm/ConfirmActualPhoneForm.jsx';
import ConfirmSecurePhoneForm from '../../components/ConfirmSecurePhoneForm/ConfirmSecurePhoneForm.jsx';

import requestPhoneConfirmationCode from '../../actions/requestPhoneConfirmationCode';
import skipAdditionalData from '../../actions/skipAdditionalData';
import approveActualPhone from '../../actions/approveActualPhone';
import Page from '../../components/Page/Page.jsx';
import Title from '../../components/Title/Title.jsx';

class PhoneRequestPage extends Component {
    constructor(props) {
        super(props);

        this.handlePhoneChange = this.handlePhoneChange.bind(this);
        this.sentConfirmationCode = this.sentConfirmationCode.bind(this);
        this.goBack = this.goBack.bind(this);
        this.confirmActualPhone = this.confirmActualPhone.bind(this);
        this.goToPhonesPage = this.goToPhonesPage.bind(this);
    }

    componentDidMount() {
        const {sendAdditionalDataRequestMetrics} = this.props;

        sendAdditionalDataRequestMetrics('show_phone', null, 'Показ');
    }

    handlePhoneChange(value) {
        const {changePhoneNumber} = this.props;

        changePhoneNumber(value);
    }

    sentConfirmationCode(event) {
        event.preventDefault();

        const {sendApiRequest, phoneNumber} = this.props;

        sendApiRequest(requestPhoneConfirmationCode, phoneNumber);
    }

    goBack() {
        const {sendApiRequest, sendAdditionalDataRequestMetrics} = this.props;

        sendAdditionalDataRequestMetrics('skip_phone', null, 'Отложить');
        sendApiRequest(skipAdditionalData);
    }

    confirmActualPhone(event) {
        event.preventDefault();

        const {sendApiRequest, phoneId} = this.props;

        sendApiRequest(approveActualPhone, phoneId);
    }

    goToPhonesPage() {
        const {redirectToPhonesPage} = this.props;

        redirectToPhonesPage();
    }

    render() {
        const {
            isCaptchaRequired,
            phoneNumber,
            phoneActualPageTitle,
            phoneSecurePageTitle,
            errors,
            action,
            trackId
        } = this.props;

        return (
            <Page cls='phone-request' dataT='phone-request'>
                <input data-t='track_id' type='hidden' value={trackId} />

                {(action === 'add' || action === 'confirm') && (
                    <Fragment>
                        <Title>
                            {action === 'add'
                                ? i18n('_AUTH_.phone.add-phone.title.v2')
                                : i18n('_AUTH_.phone.confirm-phone.title.v2')}
                        </Title>

                        <EnterPhoneForm
                            handlePhoneChange={this.handlePhoneChange}
                            sentConfirmationCode={this.sentConfirmationCode}
                            goBack={this.goBack}
                            action={action}
                            phoneNumber={phoneNumber}
                            isCaptchaRequired={isCaptchaRequired}
                            errors={errors}
                        />
                    </Fragment>
                )}

                {action === 'admit' && (
                    <Fragment>
                        <Title>
                            <span dangerouslySetInnerHTML={{__html: phoneActualPageTitle}} />
                        </Title>

                        <ConfirmActualPhoneForm
                            confirmActualPhone={this.confirmActualPhone}
                            goToPhonesPage={this.goToPhonesPage}
                            goBack={this.goBack}
                            phoneNumber={phoneNumber}
                            isCaptchaRequired={isCaptchaRequired}
                            errors={errors}
                        />
                    </Fragment>
                )}

                {action === 'secure' && (
                    <Fragment>
                        <Title>
                            <span dangerouslySetInnerHTML={{__html: phoneSecurePageTitle}} />
                        </Title>

                        <ConfirmSecurePhoneForm
                            sentConfirmationCode={this.sentConfirmationCode}
                            goToPhonesPage={this.goToPhonesPage}
                            goBack={this.goBack}
                            phoneNumber={phoneNumber}
                            isCaptchaRequired={isCaptchaRequired}
                            errors={errors}
                        />
                    </Fragment>
                )}
            </Page>
        );
    }
}

PhoneRequestPage.propTypes = {
    isCaptchaRequired: PropTypes.bool.isRequired,
    phoneNumber: PropTypes.string,
    phoneActualPageTitle: PropTypes.string,
    phoneSecurePageTitle: PropTypes.string,
    phoneId: PropTypes.string,
    errors: PropTypes.array,
    action: PropTypes.string,
    sendApiRequest: PropTypes.func.isRequired,
    changePhoneNumber: PropTypes.func.isRequired,
    sendAdditionalDataRequestMetrics: PropTypes.func.isRequired,
    redirectToPhonesPage: PropTypes.func.isRequired,
    trackId: PropTypes.string.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(PhoneRequestPage);
