export default function mapStateToProps(state) {
    const {
        additionalDataRequest: {
            phone,
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors,
            track_id: trackId
        }
    } = state;

    const squashedPhoneNumber = phone.number.replace(/ /gi, '&nbsp;');
    const phoneActualPageTitle = i18n('_AUTH_.phone.actual.title.v2').replace('%1', `<b>${squashedPhoneNumber}</b>`);
    const phoneSecurePageTitle = i18n('_AUTH_.phone.secure.title.v2').replace('%1', `<b>${squashedPhoneNumber}</b>`);

    return {
        confirmationCode,
        isConfirmationCodeSent,
        isCaptchaRequired,
        action,
        denyResendUntil,
        errors,
        phoneActualPageTitle,
        phoneSecurePageTitle,
        phoneNumber: phone.number,
        phoneId: phone.id,
        trackId
    };
}
