import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import {PREREGISTER_PAGE, PREREGISTER_SHOW_PAGE} from '../../metrics_constants';
import metrics from '../../../metrics';

import Page from '../../components/Page/Page.jsx';
import Title from '../../components/Title/Title.jsx';
import PreRegisterForm from '../../components/PreRegisterForm/PreRegisterForm.jsx';
import {SocialBlock} from '../../components/SocialBlock';

class PreRegisterPage extends Component {
    componentDidMount() {
        const {setupBackPane, setupMode, setupPane, addUserUrl, preRegisterUrl, isAm} = this.props;

        if (!isAm) {
            setupBackPane(addUserUrl);
        }
        setupMode('preRegister');
        setupPane(preRegisterUrl);
        metrics.send([PREREGISTER_PAGE, PREREGISTER_SHOW_PAGE]);
    }

    render() {
        return (
            <Page cls='pre-register' dataT='pre-register'>
                <Title>{i18n('_AUTH_.prereg.title')}</Title>

                <PreRegisterForm />

                <SocialBlock isRegister={true} />
            </Page>
        );
    }
}

PreRegisterPage.propTypes = {
    setupBackPane: PropTypes.func.isRequired,
    setupMode: PropTypes.func.isRequired,
    setupPane: PropTypes.func.isRequired,
    addUserUrl: PropTypes.string.isRequired,
    preRegisterUrl: PropTypes.string.isRequired,
    isAm: PropTypes.bool.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(PreRegisterPage);
