import React from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import mapStateToProps from './mapStateToProps';
import Page from '@blocks/authv2/components/Page/Page';
import Title from '@blocks/authv2/components/Title/Title';
import getLiteRegisterTrack from '@blocks/authv2/actions/registerLite/getRegistrationTrack';
import EnterEmailCode from '@blocks/authv2/components/RegisterLite/EnterEmailCode/EnterEmailCode';

import metrics from '@blocks/metrics';
import {REGISTER_LITE_CODE_PAGE_SHOW} from '@blocks/authv2/metrics_constants';

class RegisterLiteEnterCode extends React.PureComponent {
    componentDidMount() {
        this.props.dispatch(getLiteRegisterTrack());

        metrics.send([REGISTER_LITE_CODE_PAGE_SHOW]);
    }

    render() {
        const {login} = this.props;
        const titleText = i18n('_AUTH_.reg.lite_send-code')
            .replace('%', login)
            .replace('<strong>', '')
            .replace('</strong>', '');

        return (
            <Page dataT='register-lite-enter'>
                <Title>
                    <span>{titleText}</span>
                </Title>

                <EnterEmailCode />
            </Page>
        );
    }
}

export default connect(mapStateToProps)(RegisterLiteEnterCode);

RegisterLiteEnterCode.propTypes = {
    dispatch: PropTypes.func.isRequired,
    login: PropTypes.string
};
