import React, {useEffect} from 'react';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';
import Eula from '../../../components/RegisterLite/Eula/Eula.jsx';
import metrics from '../../../../metrics';
import {REGISTER_LITE_EULA_PAGE_SHOW} from '../../../metrics_constants';

const EulaPage = () => {
    useEffect(() => {
        metrics.send([REGISTER_LITE_EULA_PAGE_SHOW]);
    }, []);

    return (
        <Page dataT='register-lite-eula'>
            <Title>{i18n('_AUTH_.acceptance.popup.title')}</Title>
            <Eula />
        </Page>
    );
};

export default EulaPage;
