import React, {useEffect} from 'react';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';
import Form from '../../../components/RegisterLite/Form/Form.jsx';
import metrics from '../../../../metrics';
import {REGISTER_LITE_PASSWORD_PAGE_SHOW} from '../../../metrics_constants';

const RegisterLitePasswordForm = () => {
    useEffect(() => {
        metrics.send([REGISTER_LITE_PASSWORD_PAGE_SHOW]);
    }, []);

    return (
        <Page dataT='register-lite-password'>
            <Title>{i18n('_AUTH_.field_password')}</Title>
            <Form />
        </Page>
    );
};

export default RegisterLitePasswordForm;
