import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import AccountList from '../../../components/RestoreLogin/AccountList/AccountList.jsx';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';

import mapStateToProps from './mapStateToProps';

class AccountListPage extends Component {
    render() {
        return (
            <Page cls='restore-login-account-list' dataT='restore-login-account-list'>
                <Title>{this.props.pageTitle}</Title>

                <input data-t='track_id' type='hidden' value={this.props.trackId} />

                <AccountList />
            </Page>
        );
    }
}

AccountListPage.propTypes = {
    pageTitle: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired
};

export default connect(mapStateToProps)(AccountListPage);
