export default function mapStateToProps(state) {
    const {
        restoreLogin: {
            accounts,
            errors: {phone: phoneError}
        },
        common: {track_id: trackId}
    } = state;
    const hasAccounts = (accounts || []).length > 0;

    let pageTitle = hasAccounts ? i18n('OneDomik.RestoreLogin.result.title') : i18n('Profile.restore.login.name-error');

    if (phoneError === 'notFound') {
        pageTitle = i18n('OneDomik.RestoreLogin.not-found-phone.title');
    }

    return {
        pageTitle,
        trackId
    };
}
