import React, {Component} from 'react';

import EnterNameForm from '../../../components/RestoreLogin/EnterNameForm/EnterNameForm.jsx';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';

import metrics from '../../../../metrics';
import {RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SHOW_ENTER_NAME_PAGE} from '../../../metrics_constants';

class EnterNamePage extends Component {
    componentDidMount() {
        metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SHOW_ENTER_NAME_PAGE]);
    }

    render() {
        return (
            <Page cls='restore-login-enter-name' dataT='restore-login-enter-name'>
                <Title>{i18n('OneDomik.RestoreLogin.enter-name.title')}</Title>

                <EnterNameForm />
            </Page>
        );
    }
}

export default EnterNamePage;
