import React, {Component} from 'react';

import EnterPhoneForm from '../../../components/RestoreLogin/EnterPhoneForm/EnterPhoneForm.jsx';
import Title from '../../../components/Title/Title.jsx';
import Page from '../../../components/Page/Page.jsx';

import metrics from '../../../../metrics';
import {RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SHOW_ENTER_PHONE_PAGE} from '../../../metrics_constants';

class EnterPhonePage extends Component {
    componentDidMount() {
        metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SHOW_ENTER_PHONE_PAGE]);
    }

    render() {
        return (
            <Page cls='restore-login-enter-phone' dataT='restore-login-enter-phone'>
                <Title>{i18n('OneDomik.RestoreLogin.enter-phone.title')}</Title>

                <EnterPhoneForm />
            </Page>
        );
    }
}

export default EnterPhonePage;
