import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';
import BindPhone from '../../../components/RestorePassword/BindPhone/BindPhone.jsx';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId';

class BindPhonePage extends Component {
    render() {
        const {title, confirmationType} = this.props;

        return (
            <Page cls='restore-phone-bind passp-restore-password' dataT='restore-phone-bind'>
                <Title>{title}</Title>
                <BindPhone confirmationType={confirmationType} />
                <TestingTrackId />
            </Page>
        );
    }
}

BindPhonePage.propTypes = {
    title: PropTypes.string.isRequired,
    confirmationType: PropTypes.string
};

export default connect(mapStateToProps)(BindPhonePage);
