export default function mapStateToProps(state) {
    const {
        restorePassword: {processState = {}, selectedMethod}
    } = state;
    const {isForcePasswordChange, isNewMethodBindRequired} = processState;
    const title =
        isForcePasswordChange || isNewMethodBindRequired
            ? i18n('_AUTH_.RestorePassword.finish_bind-phone')
            : selectedMethod === 'email'
            ? i18n('_AUTH_.restore.email.suggest-text')
            : i18n('_AUTH_.RestorePassword.bind.phone');
    const type = isForcePasswordChange || isNewMethodBindRequired ? 'restoreBind' : 'confirmAndBindSecure';

    return {
        title,
        confirmationType: type
    };
}
