import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import Page from '../../../components/Page/Page.jsx';
import EnterCaptcha from '../../../components/RestorePassword/Captcha/EnterCaptcha.jsx';
import Title from '../../../components/Title/Title.jsx';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId';
import mapStateToProps from './mapStateToProps';

class CaptchaPage extends Component {
    render() {
        const {trackId} = this.props;

        return (
            <Page cls='restore-captcha passp-restore-password' dataT='restore-captcha'>
                <Title>{i18n('_AUTH_.enter_captcha_label')}</Title>
                <EnterCaptcha />
                <TestingTrackId trackId={trackId} />
            </Page>
        );
    }
}

export default connect(mapStateToProps)(CaptchaPage);

CaptchaPage.propTypes = {
    trackId: PropTypes.string
};
