import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import {Button} from '@components/Button';
import Page from '../../../components/Page/Page.jsx';
import EnterPassword from '../../../components/RestorePassword/FinishRestoration/FinishRestoration.jsx';
import Title from '../../../components/Title/Title.jsx';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId';

class RestorePasswordPage extends Component {
    componentDidUpdate() {
        if (this.props.isRestorationDone) {
            this.buttonRef && this.buttonRef.focus();
        }
    }

    render() {
        const {isRestorationDone, titleText, finalRetpath, trackId} = this.props;

        return (
            <Page
                cls={classnames('restore-pwd-finish', {'passp-restore-password': !isRestorationDone})}
                dataT='restore-finish'
            >
                <Title>{titleText}</Title>
                {isRestorationDone ? (
                    <div className='restore-method-wrap'>
                        <Button
                            controlRef={(ref) => (this.buttonRef = ref)}
                            url={finalRetpath}
                            onClick={this.validateForm}
                            type='link'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            width='max'
                            size='l'
                        />
                    </div>
                ) : (
                    <EnterPassword />
                )}
                <TestingTrackId trackId={trackId} />
            </Page>
        );
    }
}

export default connect(mapStateToProps)(RestorePasswordPage);

RestorePasswordPage.propTypes = {
    isRestorationDone: PropTypes.bool,
    titleText: PropTypes.string,
    finalRetpath: PropTypes.string,
    trackId: PropTypes.string
};
