export default function mapStateToProps(state) {
    const {
        common: {retpath, profile_url: profileUrl},
        restorePassword: {processState = {}, trackId}
    } = state;
    const {isRestorationDone} = processState;
    const titleText = isRestorationDone
        ? i18n('_AUTH_.RestorePassword.restoration.done')
        : i18n('_AUTH_.RestorePassword.finish.title');
    const finalRetpath = retpath || profileUrl;

    return {
        isRestorationDone,
        titleText,
        finalRetpath,
        trackId
    };
}
