import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import Title from '../../../components/Title/Title.jsx';
import {Button} from '@components/Button';
import Page from '../../../components/Page/Page.jsx';
import PhoneConfirm from '../../../components/RestorePassword/PhoneConfirm/PhoneConfirm.jsx';
import EmailConfirm from '../../../components/RestorePassword/EmailConfirm/EmailConfirm.jsx';

import setSelectedMethod from '../../../actions/restorePassword/setSelectedMethod';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId';

class MethodConfirmPage extends Component {
    getFormComponent = () => {
        const {selectedMethod} = this.props;
        const componentsList = {
            phone: <PhoneConfirm />,
            email: <EmailConfirm />
        };

        return componentsList[selectedMethod];
    };

    toggleMethod = () => {
        const {selectedMethod, methods, dispatch} = this.props;
        const alternativeMethod = methods.filter((method) => method !== selectedMethod)[0];

        dispatch(setSelectedMethod(alternativeMethod));
    };

    render() {
        const {methods, restorationFormUrl, pageTitle, isSemiAutoMethodAvailable, trackId} = this.props;
        const filteredMethods = methods.filter((method) => method !== 'semi_auto');

        return (
            <Page cls='restore-confirm passp-restore-password' dataT='restore-confirm'>
                <Title>{pageTitle}</Title>
                {this.getFormComponent()}
                {filteredMethods.length > 1 && (
                    <div className={`restoration__toggle-method-btn`}>
                        <Button
                            type='button'
                            text={i18n('_AUTH_.RestorePassword.toggle.method-btn')}
                            view='pseudo'
                            width='max'
                            size='l'
                            onClick={this.toggleMethod}
                        />
                    </div>
                )}
                {isSemiAutoMethodAvailable && (
                    <div className={`restoration_form-link`}>
                        <a href={restorationFormUrl} className='link_theme_normal'>
                            {i18n('_AUTH_.RestorePassword.method.fail')}
                        </a>
                    </div>
                )}
                <TestingTrackId trackId={trackId} />
            </Page>
        );
    }
}

export default connect(mapStateToProps)(MethodConfirmPage);

MethodConfirmPage.propTypes = {
    methods: PropTypes.array,
    restorationFormUrl: PropTypes.string.isRequired,
    pageTitle: PropTypes.string.isRequired,
    selectedMethod: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    isSemiAutoMethodAvailable: PropTypes.bool,
    trackId: PropTypes.string
};
