import {getFirstSymbolForQuery} from '@blocks/utils';

export default function mapStateToProps(state) {
    const {
        restorePassword: {
            selectedMethod,
            methods,
            urls: {restorationForm},
            isPhoneValidForCall,
            trackId
        },
        am: {isAm, appId}
    } = state;
    const isSemiAutoMethodAvailable = methods.includes('semi_auto');
    const phoneTitle = isPhoneValidForCall
        ? i18n('_AUTH_.RestoreLogin.call_confirm_title')
        : i18n('_AUTH_.RestorePassword.phone.confirm.title');
    const titles = {
        phone: phoneTitle,
        email: i18n('_AUTH_.RestorePassword.email.confirm.title')
    };

    return {
        methods,
        isSemiAutoMethodAvailable,
        selectedMethod,
        restorationFormUrl:
            isAm && appId
                ? `${restorationForm}${getFirstSymbolForQuery(restorationForm)}app_id=${appId}`
                : restorationForm,
        trackId,
        pageTitle: titles[selectedMethod] || i18n('_AUTH_.RestorePassword.title')
    };
}
