import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Button} from '@components/Button';
import {Link} from '@components/Link';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';
import PhoneStart from '../../../components/RestorePassword/Phone/PhoneStart.jsx';
import EmailStart from '../../../components/RestorePassword/Email/EmailStart.jsx';
import QuestionStart from '../../../components/RestorePassword/Question/QuestionStart.jsx';
import mapStateToProps from './mapStateToProps';
import setSelectedMethod from '../../../actions/restorePassword/setSelectedMethod';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_NOT_ABLE_TO_RESTORE} from '../../../metrics_constants';
import metrics from '../../../../metrics';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId';

class MethodPage extends Component {
    getFormComponent = () => {
        const {selectedMethod} = this.props;
        const componentsList = {
            phone: <PhoneStart />,
            email: <EmailStart />,
            hint: <QuestionStart />
        };

        return componentsList[selectedMethod];
    };

    toggleMethod = () => {
        const {selectedMethod, methods = [], dispatch} = this.props;
        const alternativeMethod = methods.filter((method) => method !== selectedMethod)[0];

        dispatch(setSelectedMethod(alternativeMethod));
    };

    sendMetricsData = () => {
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_NOT_ABLE_TO_RESTORE]);
    };

    render() {
        const {restorationFormUrl, pageTitle, methods, isSemiAutoMethodAvailable, trackId} = this.props;
        const filteredMethods = methods.filter((method) => method !== 'semi_auto');

        return (
            <Page cls='restore-method passp-restore-password' dataT='restore-method'>
                <Title>{pageTitle}</Title>
                <div className={`restore-method-wrap`}>
                    {this.getFormComponent()}

                    {filteredMethods.length > 1 && (
                        <div className={`restoration__toggle-method-btn`}>
                            <Button
                                type='button'
                                text={i18n('_AUTH_.RestorePassword.toggle.method-btn')}
                                view='pseudo'
                                width='max'
                                size='l'
                                onClick={this.toggleMethod}
                            />
                        </div>
                    )}
                    {isSemiAutoMethodAvailable && (
                        <div className={`restoration_form-link`}>
                            <Link href={restorationFormUrl} onClick={this.sendMetricsData} weight='medium'>
                                {i18n('_AUTH_.RestorePassword.method.fail')}
                            </Link>
                        </div>
                    )}
                </div>
                <TestingTrackId trackId={trackId} />
            </Page>
        );
    }
}

export default connect(mapStateToProps)(MethodPage);

MethodPage.propTypes = {
    restorationFormUrl: PropTypes.string.isRequired,
    pageTitle: PropTypes.string.isRequired,
    methods: PropTypes.array,
    selectedMethod: PropTypes.string,
    isSemiAutoMethodAvailable: PropTypes.bool,
    trackId: PropTypes.string,
    dispatch: PropTypes.func.isRequired
};
