import {getFirstSymbolForQuery} from '@blocks/utils';

export default function mapStateToProps(state) {
    const {
        restorePassword: {
            selectedMethod,
            methods,
            urls: {restorationForm},
            trackId
        },
        am: {isAm, appId}
    } = state;
    const isSemiAutoMethodAvailable = methods.includes('semi_auto');
    const titles = {
        phone: i18n('_AUTH_.RestorePassword.confirm.phone.title'),
        email: i18n('_AUTH_.RestorePassword.confirm.email.title'),
        hint: i18n('_AUTH_.RestorePwd.question_label')
    };

    return {
        selectedMethod,
        isSemiAutoMethodAvailable,
        methods,
        restorationFormUrl:
            isAm && appId
                ? `${restorationForm}${getFirstSymbolForQuery(restorationForm)}app_id=${appId}`
                : restorationForm,
        pageTitle: titles[selectedMethod] || i18n('_AUTH_.RestorePassword.title'),
        trackId
    };
}
