import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import Page from '../../../components/Page/Page.jsx';
import Title from '../../../components/Title/Title.jsx';

class RestoreNotifyPage extends Component {
    render() {
        const {title, text, authUrl, status} = this.props;

        return (
            <Page cls='restore-password' dataT='restore-password'>
                <Title>
                    <span dangerouslySetInnerHTML={{__html: title}} />
                </Title>
                <div className={`passp-normal_margin-form`}>
                    <p className='restore-password-info' dangerouslySetInnerHTML={{__html: text}} />
                    {!status && <a href={authUrl}>{i18n('_AUTH_.next_registration_step')}</a>}
                </div>
            </Page>
        );
    }
}

export default connect(mapStateToProps)(RestoreNotifyPage);

RestoreNotifyPage.propTypes = {
    title: PropTypes.string.isRequired,
    text: PropTypes.string.isRequired,
    authUrl: PropTypes.string,
    status: PropTypes.string
};
