export default function mapStateToProps(state) {
    const {
        settings: {tld},
        auth: {form = {}},
        common: {authUrl},
        restorePassword: {processState = {}}
    } = state;
    const SUPPORT_FORM_LINK = `https://forms.yandex.${tld}/surveys/10017661.7f6139870b0419a229a18ffa14b146edbd848ee8/`;
    const {status} = processState;
    const {login} = form;
    const notifyTexts = {
        password_change_forbidden: i18n('_AUTH_.pdd_password_change_forbidden'),
        complete_autoregistered: i18n('_AUTH_.restore_complete_autoregistered_link').replace(
            '%link',
            SUPPORT_FORM_LINK
        ),
        complete_pdd: i18n('_AUTH_.request_pdd_admin'),
        domain_not_served: i18n('_AUTH_.restore_domain_not_served'),
        phone_alias_prohibited: i18n('_AUTH_.restore.phone.alias'),
        complete_social: i18n('_AUTH_.social_without_password')
    };

    return {
        title: login
            ? i18n('_AUTH_.title.restorefor').replace('%1', `<br/><strong>${login}</strong>`)
            : i18n('_AUTH_.title_restore'),
        text: notifyTexts[status] || i18n('_AUTH_.ErrorsTexts.title.error'),
        authUrl,
        status
    };
}
