import React, {Component} from 'react';
import PropTypes from 'prop-types';
import Page from '../../../components/Page/Page.jsx';
import EnterLogin from '../../../components/RestorePassword/StartRestoration/EnterLogin.jsx';
import Title from '../../../components/Title/Title.jsx';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId.jsx';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';

class RestorePasswordPage extends Component {
    render() {
        const {trackId} = this.props;

        return (
            <Page cls='restore-start passp-restore-password' dataT='restore-start'>
                <Title>{i18n('_AUTH_.RestorePassword.id-page.title')}</Title>
                <EnterLogin />
                <TestingTrackId trackId={trackId} />
            </Page>
        );
    }
}

export default connect(mapStateToProps)(RestorePasswordPage);

RestorePasswordPage.propTypes = {
    trackId: PropTypes.string
};
