import loadable from '@loadable/component';
import {LoadableFallback} from '@components/LoadableFallback';

const loadableOptions = {fallback: LoadableFallback()};
const LoadableRestorePasswordPage = loadable(
    () => import(/* webpackChunkName: "RestorePasswordStart" */ './Start/RestorePasswordStart.jsx'),
    loadableOptions
);
const LoadableRestoreCaptcha = loadable(
    () => import(/* webpackChunkName: "CaptchaPage" */ './CaptchaPage/CaptchaPage.jsx'),
    loadableOptions
);
const LoadableMethodPage = loadable(
    () => import(/* webpackChunkName: "MethodPage" */ './MethodPage/MethodPage.jsx'),
    loadableOptions
);
const LoadableMethodConfirmPage = loadable(
    () => import(/* webpackChunkName: "MethodConfirmPage" */ './MethodConfirmPage/MethodConfirmPage.jsx'),
    loadableOptions
);
const LoadableFinishPage = loadable(
    () => import(/* webpackChunkName: "RestorePasswordFinish" */ './Finish/RestorePasswordFinish.jsx'),
    loadableOptions
);
const LoadableBindPhonePage = loadable(
    () => import(/* webpackChunkName: "BindPhonePage" */ './BindPhone/BindPhonePage.jsx'),
    loadableOptions
);
const LoadableBindHintPage = loadable(
    () => import(/* webpackChunkName: "BindHintPage" */ './BindHint/BindHintPage.jsx'),
    loadableOptions
);
const LoadableBindConfirmPage = loadable(
    () => import(/* webpackChunkName: "BindConfirmPage" */ './BindPhone/BindConfirmPage.jsx'),
    loadableOptions
);
const LoadableRestoreNotify = loadable(
    () => import(/* webpackChunkName: "NotifyPage" */ './Notify/NotifyPage.jsx'),
    loadableOptions
);

const restorePasswordRoutes = [
    {
        path: '/auth/restore/password/notify',
        exact: true,
        component: LoadableRestoreNotify
    },
    {
        path: '/auth/restore/password',
        exact: true,
        component: LoadableRestorePasswordPage
    },
    {
        path: '/auth/restore/password/captcha',
        exact: true,
        component: LoadableRestoreCaptcha
    },
    {
        path: '/auth/restore/password/method',
        exact: true,
        component: LoadableMethodPage
    },
    {
        path: '/auth/restore/password/method-confirm',
        exact: true,
        component: LoadableMethodConfirmPage
    },
    {
        path: '/auth/restore/password/finish',
        exact: true,
        component: LoadableFinishPage
    },
    {
        path: '/auth/restore/password/bind-phone',
        exact: true,
        component: LoadableBindPhonePage
    },
    {
        path: '/auth/restore/password/bind-hint',
        exact: true,
        component: LoadableBindHintPage
    },
    {
        path: '/auth/restore/password/bind-phone-confirm',
        exact: true,
        component: LoadableBindConfirmPage
    }
];

export default restorePasswordRoutes;
