import './WelcomePage.styl';
import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {SHOW_PASSWORD_FORM_GOAL} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import PasswordForm from '@blocks/authv2/components/PasswordForm/PasswordForm.jsx';
import {SocialButton} from '@blocks/authv2/components/SocialButton';
import {SamlSsoButton} from '@blocks/authv2/components/SamlSsoButton';
import AuthLetterButton from '@blocks/authv2/components/AuthLetterButton/AuthLetterButton.jsx';
import AuthMessengerButton from '@blocks/authv2/components/MessengerAuth/AuthMessengerButton/AuthMessengerButton.jsx';
import Page from '@blocks/authv2/components/Page/Page.jsx';
import Title from '@blocks/authv2/components/Title/Title.jsx';
import {AuthBySMSButton} from '@blocks/authv2/components/AuthBySMSButton';
import {RestoreNeoPhonishButton} from '@blocks/authv2/components/RestoreNeoPhonishButton';

const b = cn('WelcomePage');

class WelcomePage extends Component {
    componentDidMount() {
        const {
            setupBackPane,
            addUserUrl,
            editUrl,
            welcomeUrl,
            setupMode,
            setupPane,
            backPane,
            hasUnitedAccounts,
            updateLoginValue,
            enableAuthMailStatus,
            account,
            login,
            isAm,
            isSocialAccount,
            isForceMailAuthEnable,
            isMailAuthEnabled,
            mailAuthExperiment,
            disableAuthMailStatus,
            hasOnlyOneSuggestedAccount,
            neoPhonishPrefix
        } = this.props;

        metrics.goal(SHOW_PASSWORD_FORM_GOAL);

        if (!isAm && (!backPane || backPane === welcomeUrl)) {
            if (hasUnitedAccounts) {
                if (!hasOnlyOneSuggestedAccount) {
                    setupBackPane(editUrl);
                }
            } else {
                setupBackPane(addUserUrl);
            }
        }

        if (!login && !isSocialAccount && account && account.login && !account.login.startsWith(neoPhonishPrefix)) {
            updateLoginValue(account.login);
        }

        if (isForceMailAuthEnable && !mailAuthExperiment) {
            enableAuthMailStatus();
        }

        if (!isForceMailAuthEnable && isMailAuthEnabled && !mailAuthExperiment) {
            disableAuthMailStatus();
        }

        setupMode('welcome');
        setupPane(welcomeUrl);
    }

    componentWillUnmount() {
        const {updatePasswordValue, changeNativeInputValue} = this.props;

        updatePasswordValue('');
        changeNativeInputValue('passwd', '');
    }

    maybeRenderOtherAuthMethods = () => {
        const {
            isShowMailAuthBtn,
            isShowMessengerAuthBtn,
            isShowSMSAuthBtn,
            isShowSamlSsoButton,
            isShowRestoreNeoPhonishButton
        } = this.props;

        if (
            !isShowSMSAuthBtn &&
            !isShowMessengerAuthBtn &&
            !isShowMailAuthBtn &&
            !isShowRestoreNeoPhonishButton &&
            !isShowSamlSsoButton
        ) {
            return null;
        }

        return (
            <>
                {isShowSamlSsoButton && (
                    <div className={b('otherMethod')}>
                        <SamlSsoButton />
                    </div>
                )}

                {isShowSMSAuthBtn && (
                    <div className={b('otherMethod')}>
                        <AuthBySMSButton />
                    </div>
                )}

                {isShowMessengerAuthBtn && (
                    <div className={b('otherMethod')}>
                        <AuthMessengerButton />
                    </div>
                )}

                {isShowMailAuthBtn && (
                    <div className={b('otherMethod')}>
                        <AuthLetterButton />
                    </div>
                )}

                {isShowRestoreNeoPhonishButton && (
                    <div className={b('otherMethod')}>
                        <RestoreNeoPhonishButton />
                    </div>
                )}
            </>
        );
    };

    render() {
        const {
            customTagline,
            hasSocialButton,
            isFullScreen,
            isShowPasswordField,
            isShowMailAuthBtn,
            isShowMessengerAuthBtn,
            isForceMailAuthEnable,
            isMailAuthCaptchaRequired,
            isMessengerAuthCaptchaRequired
        } = this.props;

        return (
            <Page cls='welcome' dataT='welcome'>
                <Title>
                    <span className={b('tagline', {isFullScreen})} dangerouslySetInnerHTML={{__html: customTagline}} />
                </Title>

                {(!isShowMailAuthBtn || (isShowMailAuthBtn && !isMailAuthCaptchaRequired)) &&
                    (!isShowMessengerAuthBtn || (isShowMessengerAuthBtn && !isMessengerAuthCaptchaRequired)) && (
                        <React.Fragment>
                            <PasswordForm
                                hasSocialButton={hasSocialButton}
                                isForceMailAuthEnable={isForceMailAuthEnable}
                            />

                            {hasSocialButton && <SocialButton isShowPasswordField={isShowPasswordField} />}
                        </React.Fragment>
                    )}

                {this.maybeRenderOtherAuthMethods()}
            </Page>
        );
    }
}

WelcomePage.propTypes = {
    addUserUrl: PropTypes.string.isRequired,
    editUrl: PropTypes.string.isRequired,
    welcomeUrl: PropTypes.string.isRequired,
    backPane: PropTypes.string,
    hasUnitedAccounts: PropTypes.bool.isRequired,
    customTagline: PropTypes.string.isRequired,
    account: PropTypes.shape({
        login: PropTypes.string
    }).isRequired,
    login: PropTypes.string,
    isAm: PropTypes.bool.isRequired,
    isFullScreen: PropTypes.bool,
    hasSocialButton: PropTypes.bool.isRequired,
    isShowPasswordField: PropTypes.bool.isRequired,
    isShowMailAuthBtn: PropTypes.bool.isRequired,
    isForceMailAuthEnable: PropTypes.bool.isRequired,
    isSocialAccount: PropTypes.bool.isRequired,
    isShowMessengerAuthBtn: PropTypes.bool,
    updatePasswordValue: PropTypes.func.isRequired,
    updateLoginValue: PropTypes.func.isRequired,
    setupBackPane: PropTypes.func.isRequired,
    setupMode: PropTypes.func.isRequired,
    setupPane: PropTypes.func.isRequired,
    changeNativeInputValue: PropTypes.func.isRequired,
    enableAuthMailStatus: PropTypes.func.isRequired,
    isMailAuthEnabled: PropTypes.bool,
    mailAuthExperiment: PropTypes.string,
    disableAuthMailStatus: PropTypes.func.isRequired,
    hasOnlyOneSuggestedAccount: PropTypes.bool.isRequired,
    isMailAuthCaptchaRequired: PropTypes.bool.isRequired,
    isMessengerAuthCaptchaRequired: PropTypes.bool.isRequired,
    isShowSMSAuthBtn: PropTypes.bool.isRequired,
    isShowSamlSsoButton: PropTypes.bool.isRequired,
    isShowRestoreNeoPhonishButton: PropTypes.bool,
    neoPhonishPrefix: PropTypes.string
};

export default connect(mapStateToProps, mapDispatchToProps)(WelcomePage);
