import {bindActionCreators} from 'redux';

import {setupPane} from '../../../common/actions';
import {
    updateLoginValue,
    updatePasswordValue,
    setupBackPane,
    setupMode,
    enableAuthMailStatus,
    setMagicLinkDisabled
} from '../../actions';
import changeNativeInputValue from '../../actions/changeNativeInputValue';

export default function mapDispatchToProps(dispatch) {
    const actionCreators = {
        updatePasswordValue,
        updateLoginValue,
        setupBackPane,
        setupMode,
        setupPane,
        changeNativeInputValue,
        enableAuthMailStatus,
        disableAuthMailStatus: setMagicLinkDisabled
    };

    return Object.assign({}, bindActionCreators(actionCreators, dispatch), {dispatch});
}
