import {hasExp} from '@blocks/selectors';
import {getAccountTypeByAlias, ACCOUNT_TYPES} from '@blocks/authv2/utils/accountTypes';

const SOCIAL_AUTH_METHODS = [
    'social_gg',
    'social_fb',
    'social_tw',
    'social_mr',
    'social_vk',
    'social_ok',
    'social_esia'
];

export default function mapStateToProps(state) {
    const {
        common: {addUserUrl, editUrl, welcomeUrl, backPane, neoPhonishPrefix, isWebView, isWebViewWithSocialAuth},
        auth: {
            processedAccount: account,
            form: {login, isForceOTP},
            unitedAccounts = {},
            isWelcomePageTitleExp,
            suggestedAccounts = []
        },
        customs: {hideSocialBlock = false, tagline = null, taglinePassword = null, isFullScreen = false},
        social: {providers},
        mailAuth: {mailAuthExperiment, mailAuthError, isUpdatedAuthLetterStatus},
        messengerAuth: {isEnabled: isMessengerAuthShouldBeEnabled, error: messengerAuthError},
        am = {}
    } = state;
    const {
        phone,
        allowed_auth_methods: allowedAuthMethods = [],
        preferred_auth_method: preferredAuthMethod,
        primaryAliasType,
        samlSsoUrl = ''
    } = account || {};
    const hasUnitedAccounts = Object.keys(unitedAccounts).length > 0;
    const isMailAuthEnabled =
        getAccountTypeByAlias(primaryAliasType) === ACCOUNT_TYPES.LITE || preferredAuthMethod === 'magic_link';

    let authMethod = preferredAuthMethod || 'password';

    if (allowedAuthMethods.indexOf('otp') > -1 && isForceOTP) {
        authMethod = 'otp';
    }

    const provider =
        providers.filter(
            ({data}) => `social_${data.code}` === authMethod || allowedAuthMethods.includes(`social_${data.code}`)
        )[0] || null;

    let customTagline = i18n('_AUTH_.sign_in_title');

    // Удалить после решения PASSP-22837
    const isSocialAccount = Boolean(
        allowedAuthMethods.length &&
            !allowedAuthMethods.some((method) => method.indexOf('social_') === -1 && method !== 'magic_x_token')
    );

    const hasSocialButton =
        !hideSocialBlock &&
        (isWebViewWithSocialAuth || !isWebView) &&
        (Boolean(SOCIAL_AUTH_METHODS.indexOf(authMethod) > -1 && provider) ||
            allowedAuthMethods.some((method) => method.indexOf('social_') !== -1) ||
            isSocialAccount);
    const isShowPasswordField = Boolean(authMethod === 'password' || allowedAuthMethods.indexOf('password') > -1);
    const isShowOTPField = Boolean(authMethod === 'otp' || allowedAuthMethods.indexOf('otp') > -1);
    const isShowAuthLetterButton = Boolean(allowedAuthMethods.indexOf('magic_link') > -1);
    const isShowSMSAuthBtn =
        allowedAuthMethods.includes('sms_code') && (hasExp(state, 'sms-auth-on') || allowedAuthMethods.length === 1);
    const isMagicLinkOnly =
        (allowedAuthMethods.length === 1 && allowedAuthMethods[0] === 'magic_link') ||
        (allowedAuthMethods.includes('sms_code') &&
            allowedAuthMethods.includes('magic_link') &&
            allowedAuthMethods.length === 2 &&
            !(isShowSMSAuthBtn && isShowPasswordField));
    const isShowMagicLinkBtn = isShowAuthLetterButton || isUpdatedAuthLetterStatus;
    const isMessengerAuthEnabled = isMessengerAuthShouldBeEnabled && !isMagicLinkOnly;
    const isMessengerAuthCaptchaRequired = messengerAuthError === 'captcha.required';
    const isShowSamlSsoButton = Boolean(samlSsoUrl);

    // Эксперименты авторизации через мэссенджер и письмо - это два взаимоисключающих эксперимента.
    // Авторизация через мессенжер важнее!
    const isShowMessengerAuthBtn = !isShowSMSAuthBtn && isShowMagicLinkBtn && isMessengerAuthEnabled;
    const isShowMailAuthBtn =
        isShowMagicLinkBtn &&
        !isShowMessengerAuthBtn &&
        isMailAuthEnabled &&
        !(isShowSMSAuthBtn && isShowPasswordField);
    const isShouldFallbackToPassword = !isShowPasswordField && !isShowOTPField && !hasSocialButton && !isMagicLinkOnly;
    const isMailAuthCaptchaRequired = mailAuthError === 'captcha.required';
    const hasOnlyOneSuggestedAccount = suggestedAccounts.length === 1;
    const isShowRestoreNeoPhonishButton =
        !allowedAuthMethods.includes('sms_code') && !!phone && hasExp(state, 'domik-neophonish-exp-enable');

    if (isWelcomePageTitleExp) {
        if (isShowPasswordField || isShouldFallbackToPassword) {
            customTagline = i18n('_AUTH_.welcome_page_title.password');
        }

        if (isShowOTPField) {
            customTagline = i18n('_AUTH_.welcome_page_title.otp');
        }

        if (hasSocialButton) {
            customTagline = isShowPasswordField
                ? i18n('_AUTH_.welcome_page_title.password_and_social')
                : i18n('_AUTH_.welcome_page_title.social');
        }

        if (isMagicLinkOnly) {
            customTagline = i18n('_AUTH_.welcome_page_title.magic_mail');
        }
    }

    if (tagline || taglinePassword) {
        customTagline = tagline || taglinePassword;
    }

    return {
        addUserUrl,
        editUrl,
        welcomeUrl,
        backPane,
        hasUnitedAccounts,
        customTagline,
        account,
        login,
        isAm: Boolean(am.isAm),
        isFullScreen,
        hasSocialButton,
        isShowPasswordField,
        isShowMailAuthBtn,
        isShowMessengerAuthBtn,
        isMailAuthEnabled,
        isMailAuthCaptchaRequired,
        isMessengerAuthCaptchaRequired,
        isForceMailAuthEnable: isMagicLinkOnly,
        isMessengerAuthEnabled,
        mailAuthExperiment,
        isSocialAccount,
        hasOnlyOneSuggestedAccount,
        isShowSMSAuthBtn,
        isShowSamlSsoButton,
        isShowRestoreNeoPhonishButton,
        neoPhonishPrefix
    };
}
