import React from 'react';
import {useSelector} from 'react-redux';
import Page from '@blocks/authv2/components/Page/Page.jsx';
import {ChildLogo} from '@blocks/authv2/components/ChildLogo';
import {ChildServices} from '@blocks/authv2/components/ChildServices';
import {Button} from '@components/Button';

import {b} from './childCommon';

export function ChildChangePage() {
    const {currentUrl, retpath, yandexUrl} = useSelector(({common}) => ({
        currentUrl: common.currentUrl,
        retpath: common.retpath,
        yandexUrl: common.yandex_url
    }));

    const changeUserUrl = `/auth?mode=edit&retpath=${retpath || encodeURIComponent(currentUrl)}`;

    return (
        <Page cls={b('')} dataT='ChildChangePage'>
            <ChildLogo />
            <div className={b('description')}>{i18n('_AUTH_.child.description.if-bored')}</div>
            <ChildServices />
            <div className={b('button')}>
                <Button
                    view='action'
                    width='max'
                    size='l'
                    url={retpath || yandexUrl}
                    type='link'
                    text={retpath ? i18n('_AUTH_.child.button.to-return') : i18n('_AUTH_.child.button.to-main-yandex')}
                />
            </div>
            <Button
                width='max'
                size='l'
                view='white'
                url={changeUserUrl}
                type='link'
                text={i18n('_AUTH_.child.button.change-account')}
            />
        </Page>
    );
}

// for loadable
// else use import {ChildChangePage} from ...
export default ChildChangePage;
