import React from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {redirect} from '@blocks/authv2/actions';
import logoutAccount from '@blocks/authv2/actions/logoutAccount';
import Page from '@blocks/authv2/components/Page/Page.jsx';
import {ChildLogo} from '@blocks/authv2/components/ChildLogo';
import {ChildServices} from '@blocks/authv2/components/ChildServices';
import {Button} from '@components/Button';

import {b} from './childCommon';

export function ChildExitPage() {
    const dispatch = useDispatch();
    const {uid, authUrl, retpath, yandexUrl} = useSelector(({auth, common}) => ({
        uid: auth.processedAccount.uid,
        authUrl: common.authUrl,
        retpath: common.retpath,
        yandexUrl: common.yandex_url
    }));

    return (
        <Page cls={b('')} dataT='ChildExitPage'>
            <ChildLogo />
            <div className={b('description')}>{i18n('_AUTH_.child.description.if-bored')}</div>
            <ChildServices />
            <div className={b('button')}>
                <Button
                    view='action'
                    width='max'
                    size='l'
                    url={retpath || yandexUrl}
                    type='link'
                    text={retpath ? i18n('_AUTH_.child.button.to-return') : i18n('_AUTH_.child.button.to-main-yandex')}
                />
            </div>
            <Button
                width='max'
                size='l'
                view='white'
                onClick={() => {
                    dispatch(logoutAccount(uid));
                    redirect(retpath || authUrl);
                }}
                text={i18n('_AUTH_.child.button.go-out')}
            />
        </Page>
    );
}

// for loadable
// else use import {ChildExitPage} from ...
export default ChildExitPage;
