import React from 'react';
import {useSelector} from 'react-redux';
import Page from '@blocks/authv2/components/Page/Page.jsx';
import {ChildLogo} from '@blocks/authv2/components/ChildLogo';
import {ChildServices} from '@blocks/authv2/components/ChildServices';
import {Button} from '@components/Button';

import {b} from './childCommon';

export function ChildRestrictPage() {
    const {currentUrl, retpath} = useSelector(({common}) => ({
        currentUrl: common.currentUrl,
        retpath: common.retpath,
        yandexUrl: common.yandex_url
    }));

    const changeUserUrl = `/auth?mode=edit&retpath=${retpath || encodeURIComponent(currentUrl)}`;

    return (
        <Page cls={b('')} dataT='ChildRestrictPage'>
            <ChildLogo />
            <div className={b('title')}>{i18n('_AUTH_.child.title.grow-up')}</div>
            <div className={b('description')}>{i18n('_AUTH_.child.description.bored-things')}</div>
            <ChildServices />
            <Button
                width='max'
                size='l'
                view='transparent'
                url={changeUserUrl}
                type='link'
                text={i18n('_AUTH_.child.button.change-account')}
            />
        </Page>
    );
}

// for loadable
// else use import {ChildRestrictPage} from ...
export default ChildRestrictPage;
