import loadable from '@loadable/component';
import {LoadableFallback} from '@components/LoadableFallback';

const loadableOptions = {fallback: LoadableFallback()};

const ChildRestrict = loadable(
    () => import(/* webpackChunkName: "ChildRestrictPage" */ './ChildRestrictPage'),
    loadableOptions
);
const ChildChange = loadable(
    () => import(/* webpackChunkName: "ChildChangePage" */ './ChildChangePage'),
    loadableOptions
);
const ChildExit = loadable(() => import(/* webpackChunkName: "ChildExitPage" */ './ChildExitPage'), loadableOptions);
const ChildAdd = loadable(() => import(/* webpackChunkName: "ChildAddPage" */ './ChildAddPage'), loadableOptions);

export const authChildRoutes = [
    {
        path: '/auth/child/restrict',
        exact: true,
        component: ChildRestrict
    },
    {
        path: '/auth/child/change',
        exact: true,
        component: ChildChange
    },
    {
        path: '/auth/child/exit',
        exact: true,
        component: ChildExit
    },
    {
        path: '/auth/child/add',
        exact: true,
        component: ChildAdd
    }
];
