import {
    CHANGE_CAPTCHA_ANSWER,
    CHANGE_CAPTCHA_STATE,
    CHANGE_PHONE_NUMBER,
    CHANGE_EMAIL,
    CHANGE_CONFIRMATION_CODE,
    CHANGE_CONFIRMATION_CODE_SENT_STATUS,
    SENT_PHONE_CONFIRMATION_CODE_SUCCESS,
    SENT_EMAIL_CONFIRMATION_CODE_SUCCESS,
    CLEAR_ERRORS,
    SET_ERRORS
} from '../actions/additionalDataRequestActions';

import {INIT_ADDITIONAL_DATA_REQUEST} from '../actions';

export default function additionalDataRequest(state = {}, action) {
    switch (action.type) {
        case CHANGE_CAPTCHA_ANSWER: {
            return Object.assign({}, state, {
                captchaAnswer: action.captchaAnswer
            });
        }
        case CHANGE_CAPTCHA_STATE: {
            return Object.assign({}, state, {
                isCaptchaRequired: action.isCaptchaRequired
            });
        }
        case CHANGE_PHONE_NUMBER: {
            return Object.assign({}, state, {
                phone: Object.assign(state.phone, {
                    number: action.phoneNumber
                })
            });
        }
        case CHANGE_EMAIL: {
            return Object.assign({}, state, {
                email: action.email
            });
        }
        case CHANGE_CONFIRMATION_CODE: {
            return Object.assign({}, state, {
                confirmationCode: action.confirmationCode
            });
        }
        case CHANGE_CONFIRMATION_CODE_SENT_STATUS: {
            return Object.assign({}, state, {
                isConfirmationCodeSent: action.isConfirmationCodeSent
            });
        }
        case SENT_EMAIL_CONFIRMATION_CODE_SUCCESS: {
            return Object.assign({}, state, {
                isConfirmationCodeSent: true
            });
        }
        case SENT_PHONE_CONFIRMATION_CODE_SUCCESS: {
            const {payload} = action;

            return Object.assign({}, state, {
                phone: Object.assign(state.phone, {
                    number: payload.number.original
                }),
                denyResendUntil: payload.deny_resend_until * 1000,
                isConfirmationCodeSent: true
            });
        }
        case CLEAR_ERRORS: {
            return Object.assign({}, state, {
                errors: []
            });
        }
        case SET_ERRORS: {
            const {errors} = action;
            const isCaptchaRequired = Boolean(errors.join(',').match(/captcha\./));

            return Object.assign({}, state, {
                errors,
                isCaptchaRequired
            });
        }
        case INIT_ADDITIONAL_DATA_REQUEST: {
            const {payload} = action;
            const resultStore = {};

            Object.assign(resultStore, {
                status: 'ok',
                isConfirmationCodeSent: false,
                isCaptchaRequired: false,
                confirmationCode: '',
                errors: [],
                denyResendUntil: null
            });

            if (payload && payload.state) {
                const {phone, email, social, track_id} = payload;

                Object.assign(resultStore, {
                    state: payload.state,
                    action: payload.action,
                    track_id
                });

                if (payload.state === 'email') {
                    resultStore[payload.state] = email || '';
                } else {
                    resultStore[payload.state] = phone || social || {};
                }

                if (payload.state === 'phone') {
                    resultStore.phone.id = String(resultStore.phone.id || '');
                    resultStore.phone.number = String(resultStore.phone.number || '');
                }
            }

            return Object.assign({}, resultStore);
        }
        default:
            return state;
    }
}
